/*
 * Decompiled with CFR 0.152.
 */
package strategies;

import core.states.GameState;
import entities.Entity;
import strategies.Strategy;

public abstract class EntityStrategy
extends Strategy {
    protected Entity entity;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected long startTime = GameState.get().getTime();
    protected long time = 0L;

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void sync() throws NullPointerException {
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.dx = this.entity.getDx();
        this.dy = this.entity.getDy();
        this.time = GameState.get().getTime() - this.startTime;
        this.calculate();
        this.entity.setDx(this.dx);
        this.entity.setDy(this.dy);
    }

    @Override
    protected abstract void calculate();
}

